/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.PropertySet;
import com.roguewave.chart.core.v2_1.ViewModes;
import com.roguewave.chart.core.v2_1.events.DataUpdateEvent;
import com.roguewave.chart.core.v2_1.events.DataUpdateListener;
import com.roguewave.chart.core.v2_1.events.PropertyUpdateEvent;
import com.roguewave.chart.core.v2_1.events.PropertyUpdateListener;
import com.roguewave.chart.core.v2_1.graphics.BufferedCanvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.datamodels.v2_1.SampleData;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import com.roguewave.chart.standard.v2_1.AreaChart;
import com.roguewave.chart.standard.v2_1.ClickCBGen;
import com.roguewave.chart.standard.v2_1.ClickEventHelper;
import com.roguewave.chart.standard.v2_1.DefaultMouseListener;
import com.roguewave.chart.standard.v2_1.LineChart;
import com.roguewave.chart.standard.v2_1.MultiColumnBarChart;
import com.roguewave.chart.standard.v2_1.MultiRowBarChart;
import com.roguewave.chart.standard.v2_1.NullChart;
import com.roguewave.chart.standard.v2_1.PieChart;
import com.roguewave.chart.standard.v2_1.ScatterPlot;
import com.roguewave.chart.standard.v2_1.StackedAreaChart;
import com.roguewave.chart.standard.v2_1.StackedBarChart;
import com.roguewave.chart.standard.v2_1.StyleCustomizer;
import com.roguewave.chart.standard.v2_1.events.ChartClickListener;
import com.roguewave.chart.standard.v2_1.parts.DefaultStyleCustomizer;
import com.roguewave.chart.standard.v2_1.parts.TitlePlate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Chart
extends BufferedCanvas3D
implements DataUpdateListener,
PropertyUpdateListener,
PropertyChangeListener,
ViewModes {
    DataModel data_;
    ChartProperties properties_;
    ChartBuilder chartBuilder_;
    int viewMode_;
    Insets drawInsets_ = defaultDrawAreaInsets;
    ClickEventHelper clickHelper_;
    boolean autoScaling_ = false;
    boolean singleAutoScale_;
    MouseListener defaultMouseListener_;
    String dataFile_;
    int currentRow_ = 0;
    private transient ChartGraphics chart_;
    private transient boolean modified_;
    private transient Point3D[] bounds_;
    private transient Dimension lastSize_;
    static double defaultViewRotation = -45.0;
    static double defaultViewTilt = 20.0;
    static double defaultViewDistance = 50.0;
    static double defaultShearFactor = 0.5;
    static Insets defaultDrawAreaInsets = new Insets(45, 15, 45, 15);
    static double defaultPieRadius = 0.5;
    public static final boolean VERTICAL = true;
    public static final boolean HORIZONTAL = false;

    public Chart() {
        this.setBackground(Color.lightGray);
        this.data_ = new SampleData();
        this.properties_ = new ChartProperties();
        this.clickHelper_ = new ClickEventHelper(this, this.data_);
        ClickCBGen clickCBGen = new ClickCBGen(this.clickHelper_);
        this.properties_.setClickCallbackGenerator(clickCBGen);
        this.defaultMouseListener_ = new DefaultMouseListener(this);
        super.addMouseListener(this.defaultMouseListener_);
        this.singleAutoScale_ = true;
        this.setTitle(this.data_.getName());
        this.set2DStyleCustomizer(new DefaultStyleCustomizer());
        this.set3DStyleCustomizer(new DefaultStyleCustomizer());
        this.lastSize_ = new Dimension(0, 0);
        this.chartBuilder_ = null;
        this.viewMode_ = 2;
        this.setChartBuilder(new NullChart(), 0);
        this.dataFile_ = "";
    }

    public Chart(ChartBuilder chartBuilder, int viewMode, DataModel data) {
        this.setBackground(Color.lightGray);
        this.data_ = data;
        this.data_.addDataUpdateListener(this);
        this.properties_ = new ChartProperties();
        this.clickHelper_ = new ClickEventHelper(this, this.data_);
        ClickCBGen clickCBGen = new ClickCBGen(this.clickHelper_);
        this.properties_.setClickCallbackGenerator(clickCBGen);
        this.defaultMouseListener_ = new DefaultMouseListener(this);
        super.addMouseListener(this.defaultMouseListener_);
        this.singleAutoScale_ = true;
        this.setTitle(data.getName());
        this.set2DStyleCustomizer(new DefaultStyleCustomizer());
        this.set3DStyleCustomizer(new DefaultStyleCustomizer());
        this.lastSize_ = new Dimension(0, 0);
        if (viewMode == 1) {
            this.setTrue3DLabels(false);
        }
        this.chartBuilder_ = null;
        this.viewMode_ = viewMode == 2 ? 0 : 2;
        this.setChartBuilder(chartBuilder, viewMode);
        this.dataFile_ = "";
    }

    public void setScale(NumericFormatter formatter) {
        this.properties_.setScale(formatter);
    }

    public void setChartBuilder(ChartBuilder chartBuilder, int viewMode) {
        boolean oldWasStacked;
        if (this.data_ == null) {
            return;
        }
        this.clear();
        boolean newIsStacked = chartBuilder instanceof StackedBarChart || chartBuilder instanceof StackedAreaChart;
        boolean bl = oldWasStacked = this.chartBuilder_ instanceof StackedBarChart || this.chartBuilder_ instanceof StackedAreaChart;
        if (this.data_ != null && (this.chartBuilder_ == null || newIsStacked != oldWasStacked)) {
            if (newIsStacked) {
                this.setStackedColumnsDataRange();
            } else {
                this.properties_.setDataRange(this.data_);
            }
        }
        this.chartBuilder_ = chartBuilder;
        int oldViewMode = this.viewMode_;
        if (this.chartBuilder_.supports(viewMode)) {
            this.viewMode_ = viewMode;
        } else if (this.chartBuilder_.supports(2)) {
            System.err.println("Chart.setChartBuilder: The specified chart builder does not support the specifed view mode; using 3D view.");
            this.viewMode_ = 2;
            oldViewMode = 0;
        } else if (this.chartBuilder_.supports(0)) {
            System.err.println("Chart.setChartBuilder: The specified chart builder does not support the specifed view mode; using 2D view.");
            this.viewMode_ = 0;
            oldViewMode = 2;
        } else if (this.chartBuilder_.supports(1)) {
            System.err.println("Chart.setChartBuilder: The specified chart builder does not support the specifed view mode; using 2PT5D view.");
            this.viewMode_ = 1;
            oldViewMode = 0;
        } else {
            throw new IllegalArgumentException("Chart.setChartBuilder: The specified chart builder does not support the specified view mode or any of the standard view modes.");
        }
        try {
            this.chart_ = this.chartBuilder_.build(this.properties_, this.data_);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.valueOf("Build exception: ").concat(String.valueOf(e.getMessage())));
            this.chart_ = new NullChart().build(new ChartProperties(), null);
        }
        catch (Exception e) {
            this.chart_ = new NullChart().build(new ChartProperties(), null);
        }
        this.modified_ = false;
        if (this.chart_ == null) {
            return;
        }
        switch (this.viewMode_) {
            case 1: {
                if (oldViewMode != 1) {
                    super.setView(0.0, 0.0, 3.0);
                    super.setShear(defaultShearFactor);
                }
                this.chart_.add3DTo(this);
                this.bounds_ = this.chart_.get3DBoundingBox();
                break;
            }
            case 2: {
                if (oldViewMode != 2) {
                    super.setView(defaultViewRotation, defaultViewTilt, defaultViewDistance);
                }
                this.chart_.add3DTo(this);
                this.bounds_ = this.chart_.get3DBoundingBox();
                break;
            }
            case 0: {
                if (oldViewMode != 0) {
                    super.setView(0.0, 0.0, 3.0);
                    this.setShear(0.0);
                }
                this.chart_.add2DTo(this);
                this.bounds_ = this.chart_.get2DBoundingBox();
            }
        }
        this.lastSize_ = new Dimension(0, 0);
    }

    public void autoScale() {
        this.singleAutoScale_ = true;
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        if (this.modified_) {
            this.setChartBuilder(this.chartBuilder_, this.viewMode_);
        }
        Dimension size = this.getSize();
        if (size.width == 0 || size.height == 0) {
            return;
        }
        if (size.width != this.lastSize_.width || size.height != this.lastSize_.height) {
            this.singleAutoScale_ = true;
            this.lastSize_ = size;
        }
        if ((this.autoScaling_ || this.singleAutoScale_) && this.bounds_ != null) {
            this.setBoundingWindow(this.bounds_, this.drawInsets_);
            this.singleAutoScale_ = false;
        }
        super.update(g);
    }

    public boolean getAutoScaling() {
        return this.autoScaling_;
    }

    public void setAutoScaling(boolean flag) {
        this.autoScaling_ = flag;
    }

    public Drawable getBackgroundDrawable() {
        return (Drawable)this.properties_.getProperty("BackgroundDrawable", null);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.properties_.addProperty("BackgroundDrawable", background);
        this.modified_ = true;
    }

    public double getBasePad() {
        return (Double)this.properties_.getProperty("BasePad", new Double(0.25));
    }

    public void setBasePad(double pad) {
        this.properties_.addProperty("BasePad", new Double(pad));
        this.modified_ = true;
    }

    public ChartBuilder getChartBuilder() {
        return this.chartBuilder_;
    }

    public double getChartHeight() {
        return this.properties_.getChartHeight();
    }

    public void setChartHeight(double height) {
        this.properties_.setChartHeight(height);
        this.modified_ = true;
    }

    public String getChartType() {
        ChartBuilder builder = this.getChartBuilder();
        if (builder instanceof LineChart) {
            return "LineChart";
        }
        if (builder instanceof NullChart) {
            return "NullChart";
        }
        if (builder instanceof MultiRowBarChart) {
            return "MultiRowBarChart";
        }
        if (builder instanceof StackedBarChart) {
            return "StackedBarChart";
        }
        if (builder instanceof MultiColumnBarChart) {
            return "MultiColumnBarChart";
        }
        if (builder instanceof AreaChart) {
            return "AreaChart";
        }
        if (builder instanceof StackedAreaChart) {
            return "StackedAreaChart";
        }
        if (builder instanceof PieChart) {
            return "PieChart";
        }
        if (builder instanceof ScatterPlot) {
            return "ScatterPlot";
        }
        return "";
    }

    public void setChartType(String chartType) {
        int mode = this.getViewMode();
        if (chartType.equals("NullChart")) {
            this.setChartBuilder(new NullChart(), mode);
        } else if (chartType.equals("LineChart")) {
            this.setChartBuilder(new LineChart(), mode);
        } else if (chartType.equals("MultiColumnBarChart")) {
            this.setChartBuilder(new MultiColumnBarChart(), mode);
        } else if (chartType.equals("MultiRowBarChart")) {
            this.setChartBuilder(new MultiRowBarChart(), mode);
        } else if (chartType.equals("StackedBarChart")) {
            this.setChartBuilder(new StackedBarChart(), mode);
        } else if (chartType.equals("AreaChart")) {
            this.setChartBuilder(new AreaChart(), mode);
        } else if (chartType.equals("StackedAreaChart")) {
            this.setChartBuilder(new StackedAreaChart(), mode);
        } else if (chartType.equals("PieChart")) {
            this.setChartBuilder(new PieChart(0), mode);
        } else if (chartType.equals("ScatterPlot")) {
            int[] xi = new int[]{0};
            int[] yi = new int[]{1};
            this.setChartBuilder(new ScatterPlot(true, xi, yi), 0);
        }
    }

    public boolean getChartOrientation() {
        return this.getProperty("ChartOrientation", true);
    }

    public void setChartOrientation(boolean vertical) {
        this.setProperty("ChartOrientation", new Boolean(vertical));
    }

    public void setClickCallbackGenerator(ClickCallbackGenerator generator) {
        this.properties_.setClickCallbackGenerator(generator);
        this.modified_ = true;
    }

    public DataModel getData() {
        return this.data_;
    }

    public void setData(DataModel data) {
        if (this.data_ != null) {
            this.data_.removeDataUpdateListener(this);
        }
        data.addDataUpdateListener(this);
        this.data_ = data;
        this.clickHelper_.setData(this.data_);
        this.properties_.setDataRange(this.data_);
        if (this.chartBuilder_ instanceof StackedBarChart || this.chartBuilder_ instanceof StackedAreaChart) {
            this.setStackedColumnsDataRange();
        }
        if (!this.getTitle().equals(this.data_.getName())) {
            this.setTitle(this.data_.getName());
        }
        this.modified_ = true;
    }

    public void setDataRange(double low, double high) {
        this.properties_.setDataRangeLow(low);
        this.properties_.setDataRangeHigh(high);
        this.modified_ = true;
    }

    public double getDataRangeHigh() {
        return this.properties_.getDataRangeHigh();
    }

    public void setDataRangeHigh(double high) {
        if (this.chartBuilder_ instanceof StackedBarChart || this.chartBuilder_ instanceof StackedAreaChart) {
            double max = this.findMaxStack();
            if (high < max) {
                high = max;
            }
        } else {
            for (int row = 0; row < this.data_.getRowCount(); ++row) {
                for (int col = 0; col < this.data_.getColumnCount(); ++col) {
                    if (!(this.data_.getValue(row, col) > high)) continue;
                    high = this.data_.getValue(row, col);
                }
            }
        }
        this.properties_.setDataRangeHigh(high);
        this.modified_ = true;
    }

    public double getDataRangeLow() {
        return this.properties_.getDataRangeLow();
    }

    public void setDataRangeLow(double low) {
        for (int row = 0; row < this.data_.getRowCount(); ++row) {
            for (int col = 0; col < this.data_.getColumnCount(); ++col) {
                if (!(this.data_.getValue(row, col) < low)) continue;
                low = this.data_.getValue(row, col);
            }
        }
        this.properties_.setDataRangeLow(low);
        this.modified_ = true;
    }

    public Insets getDrawAreaInsets() {
        return this.drawInsets_;
    }

    public void setDrawAreaInsets(Insets insets) {
        this.drawInsets_ = insets;
        this.modified_ = true;
    }

    public boolean getFittedLineShown() {
        return this.properties_.getProperty("FittedLineShown", true);
    }

    public void setFittedLineShown(boolean shown) {
        this.properties_.addProperty("FittedLineShown", new Boolean(shown));
        this.modified_ = true;
    }

    public Color getGridColor() {
        return (Color)this.properties_.getProperty("GridColor", Color.black);
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            return;
        }
        this.properties_.addProperty("GridColor", gridColor);
        this.modified_ = true;
    }

    public Color getLabelColor() {
        return (Color)this.properties_.getProperty("LabelColor", Color.black);
    }

    public void setLabelColor(Color labelColor) {
        if (labelColor == null) {
            return;
        }
        this.properties_.addProperty("LabelColor", labelColor);
        this.modified_ = true;
    }

    public Font getLabelFont() {
        return (Font)this.properties_.getProperty("LabelFont", this.getFont());
    }

    public void setLabelFont(Font labelFont) {
        this.properties_.addProperty("LabelFont", labelFont);
        this.modified_ = true;
    }

    public boolean getLabelsShown() {
        return this.properties_.getProperty("LabelsShown", true);
    }

    public void setLabelsShown(boolean shown) {
        this.properties_.addProperty("LabelsShown", new Boolean(shown));
        this.modified_ = true;
    }

    public Customizer getLegend() {
        return (Customizer)this.properties_.getProperty("Legend", null);
    }

    public void setLegend(Customizer legend) {
        this.properties_.addProperty("Legend", legend);
        this.modified_ = true;
    }

    public Color getLegendBackgroundColor() {
        return (Color)this.properties_.getProperty("LegendBackgroundColor", this.getBackground());
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        if (legendBackgroundColor == null) {
            return;
        }
        this.properties_.addProperty("LegendBackgroundColor", legendBackgroundColor);
        this.modified_ = true;
    }

    public double getLegendItemBoxSize() {
        return this.properties_.getProperty("LegendItemBoxSize", 14.0);
    }

    public void setLegendItemBoxSize(double size) {
        this.properties_.addProperty("LegendItemBoxSize", new Double(size));
        this.modified_ = true;
    }

    public Font getLegendItemFont() {
        return (Font)this.properties_.getProperty("LegendItemFont", new Font("TimesRoman", 1, 14));
    }

    public void setLegendItemFont(Font legendItemFont) {
        this.properties_.addProperty("LegendItemFont", legendItemFont);
        this.modified_ = true;
    }

    public RelativePosition getLegendPosition() {
        RelativePosition defaultPosition = new RelativePosition(0.5, 1.0, 0, -12, 3);
        return (RelativePosition)this.properties_.getProperty("LegendPosition", defaultPosition);
    }

    public void setLegendPosition(RelativePosition position) {
        this.properties_.addProperty("LegendPosition", position);
        this.modified_ = true;
    }

    public Color getLegendTextColor() {
        return (Color)this.properties_.getProperty("LegendTextColor", Color.black);
    }

    public void setLegendTextColor(Color legendTextColor) {
        if (legendTextColor == null) {
            return;
        }
        this.properties_.addProperty("LegendTextColor", legendTextColor);
        this.modified_ = true;
    }

    public boolean getLegendShown() {
        return this.properties_.getProperty("LegendShown", true);
    }

    public void setLegendShown(boolean flag) {
        this.properties_.addProperty("LegendShown", new Boolean(flag));
        this.modified_ = true;
    }

    public boolean getLineSegmentOutlines() {
        return this.getProperty("LineSegmentOutlines", true);
    }

    public void setLineSegmentOutlines(boolean flag) {
        this.setProperty("LineSegmentOutlines", new Boolean(flag));
    }

    public double getLineThickness() {
        return this.getProperty("LineThickness", 0.02);
    }

    public void setLineThickness(double thickness) {
        this.setProperty("LineThickness", new Double(thickness));
    }

    public int getMarkerSize() {
        return (Integer)this.getProperty("MarkerSize", new Integer(4));
    }

    public void setMarkerSize(int size) {
        if (size < 0) {
            return;
        }
        this.setProperty("MarkerSize", new Integer(size));
    }

    protected void setModified() {
        this.modified_ = true;
    }

    public double getPartDepth() {
        return this.properties_.getProperty("PartDepth", 0.8);
    }

    public void setPartDepth(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            return;
        }
        this.properties_.addProperty("PartDepth", new Double(fraction));
        this.modified_ = true;
    }

    public double getPartWidth() {
        return this.properties_.getProperty("PartWidth", 0.8);
    }

    public void setPartWidth(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            return;
        }
        this.properties_.addProperty("PartWidth", new Double(fraction));
        this.modified_ = true;
    }

    public double getPieRadius() {
        return this.properties_.getProperty("PieRadius", defaultPieRadius);
    }

    public void setPieRadius(double radius) {
        this.properties_.addProperty("PieRadius", new Double(radius));
        this.modified_ = true;
    }

    public Color getPlatformColor() {
        return (Color)this.properties_.getProperty("PlatformColor", Color.lightGray);
    }

    public void setPlatformColor(Color color) {
        if (color == null) {
            return;
        }
        this.properties_.addProperty("PlatformColor", color);
        this.modified_ = true;
    }

    public double getPlatformHeight() {
        return this.properties_.getProperty("PlatformHeight", 0.5);
    }

    public void setPlatformHeight(double height) {
        this.properties_.addProperty("PlatformHeight", new Double(height));
        this.modified_ = true;
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.properties_.getProperty(name, defaultValue);
    }

    public boolean getProperty(String name, boolean defaultValue) {
        return this.properties_.getProperty(name, defaultValue);
    }

    public double getProperty(String name, double defaultValue) {
        return this.properties_.getProperty(name, defaultValue);
    }

    public void setProperty(String name, Object value) {
        this.properties_.addProperty(name, value);
        this.modified_ = true;
    }

    public void setProperty(PropertySet set) {
        this.properties_.addPropertySet(set);
        this.modified_ = true;
    }

    public void setProperty(String name, Object value, int row, int column, int width, int height) {
        this.properties_.addProperty(name, value, row, column, width, height);
        this.modified_ = true;
    }

    public double getRotation() {
        return super.getRotation();
    }

    public void setRotation(double degrees) {
        if (this.viewMode_ == 2) {
            super.setRotation(degrees);
            this.clear();
            this.chart_.add3DTo(this);
        }
    }

    public double getTilt() {
        return super.getTilt();
    }

    public void setTilt(double degrees) {
        if (this.viewMode_ == 2) {
            super.setTilt(degrees);
            this.clear();
            this.chart_.add3DTo(this);
        }
    }

    public Color getScaleColor() {
        return (Color)this.properties_.getProperty("ScaleColor", Color.black);
    }

    public void setScaleColor(Color scaleColor) {
        if (scaleColor == null) {
            return;
        }
        this.properties_.addProperty("ScaleColor", scaleColor);
        this.modified_ = true;
    }

    public Font getScale2DFont() {
        return (Font)this.properties_.getProperty("Scale2DFont", new Font("TimesRoman", 0, 14));
    }

    public void setScale2DFont(Font font) {
        this.properties_.addProperty("Scale2DFont", font);
        this.modified_ = true;
    }

    public double getScale3DFontSize() {
        return this.properties_.getProperty("Scale3DFontSize", 0.4);
    }

    public void setScale3DFontSize(double size) {
        this.properties_.addProperty("Scale3DFontSize", new Double(size));
        this.modified_ = true;
    }

    public double getScaleIncrement() {
        double scaleIncrement = 10.0;
        double range = this.properties_.getDataRangeHigh() - this.properties_.getDataRangeLow();
        while (range / scaleIncrement > (double)10) {
            scaleIncrement *= (double)10;
        }
        while (range / scaleIncrement < (double)5) {
            scaleIncrement /= (double)2;
        }
        return this.properties_.getProperty("ScaleIncrement", scaleIncrement);
    }

    public void setScaleIncrement(double increment) {
        if (increment <= 0.0) {
            return;
        }
        this.properties_.addProperty("ScaleIncrement", new Double(increment));
        this.modified_ = true;
    }

    public Color getRowColor(int row) {
        StandardColors stdColors = new StandardColors();
        return (Color)this.properties_.getProperty("ForegroundColor", row, 0, stdColors.color(row), 0.0);
    }

    public void setRowColor(int row, Color color) {
        if (color == null) {
            return;
        }
        this.setProperty("ForegroundColor", color, row, 0, 9999999, 1);
        this.modified_ = true;
    }

    public Color getRowColor() {
        return this.getRowColor(this.currentRow_);
    }

    public void setRowColor(Color color) {
        if (color == null) {
            return;
        }
        this.setRowColor(this.currentRow_, color);
    }

    public int getRow() {
        return this.currentRow_;
    }

    public void setRow(int row) {
        this.currentRow_ = row;
    }

    public void setStackedColumnsDataRange() {
        this.setDataRangeHigh(this.findMaxStack());
    }

    private double findMaxStack() {
        int rows = this.data_.getRowCount();
        int columns = this.data_.getColumnCount();
        double max = 0.0;
        for (int column = 0; column < columns; ++column) {
            double sum = 0.0;
            for (int row = 0; row < rows; ++row) {
                sum += this.data_.getValue(row, column);
            }
            if (column != 0 && !(sum > max)) continue;
            max = sum;
        }
        return max;
    }

    public double getStaggerDistance() {
        return this.properties_.getProperty("StaggerDistance", 0.0);
    }

    public void setStaggerDistance(double distance) {
        this.properties_.addProperty("StaggerDistance", new Double(distance));
        this.modified_ = true;
    }

    public String getTitle() {
        String defaultTitle = this.data_ == null ? "" : this.data_.getName();
        return (String)this.properties_.getProperty("Title", defaultTitle);
    }

    public void setTitle(String title) {
        this.properties_.addProperty("Title", title);
        this.modified_ = true;
    }

    public Color getTitleBackgroundColor() {
        return (Color)this.properties_.getProperty("TitleBackgroundColor", this.getBackground());
    }

    public void setTitleBackgroundColor(Color titleBackgroundColor) {
        if (titleBackgroundColor == null) {
            return;
        }
        this.properties_.addProperty("TitleBackgroundColor", titleBackgroundColor);
        this.modified_ = true;
    }

    public Color getTitleColor() {
        return (Color)this.properties_.getProperty("TitleColor", Color.black);
    }

    public void setTitleColor(Color titleColor) {
        if (titleColor == null) {
            return;
        }
        this.properties_.addProperty("TitleColor", titleColor);
        this.modified_ = true;
    }

    public Font getTitleFont() {
        return (Font)this.properties_.getProperty("TitleFont", new Font("TimesRoman", 1, 18));
    }

    public void setTitleFont(Font titleFont) {
        this.properties_.addProperty("TitleFont", titleFont);
        this.modified_ = true;
    }

    public Customizer getTitlePlate() {
        return (Customizer)this.properties_.getProperty("TitlePlate", null);
    }

    public void setTitlePlate(Customizer titlePlate) {
        this.properties_.addProperty("TitlePlate", titlePlate);
        if (titlePlate instanceof TitlePlate) {
            ((TitlePlate)titlePlate).addPropertyChangeListener(this);
        }
        this.modified_ = true;
    }

    public boolean getTitlePlateIsTransparent() {
        return this.properties_.getProperty("TitlePlateIsTransparent", false);
    }

    public void setTitlePlateIsTransparent(boolean isTransparent) {
        this.properties_.addProperty("TitlePlateIsTransparent", new Boolean(isTransparent));
        this.modified_ = true;
    }

    public int getTitlePlatePad() {
        return (Integer)this.properties_.getProperty("TitlePlatePad", new Integer(5));
    }

    public void setTitlePlatePad(int padding) {
        this.properties_.addProperty("TitlePlatePad", new Integer(padding));
        this.modified_ = true;
    }

    public int getTitleBorderWidth() {
        return (Integer)this.properties_.getProperty("TitleBorderWidth", new Integer(2));
    }

    public void setTitleBorderWidth(int width) {
        this.properties_.addProperty("TitleBorderWidth", new Integer(width));
        this.modified_ = true;
    }

    public RelativePosition getTitlePosition() {
        RelativePosition defaultPosition = new RelativePosition(0.5, 0.0, 0, 12, 0);
        return (RelativePosition)this.properties_.getProperty("TitlePosition", defaultPosition);
    }

    public void setTitlePosition(RelativePosition position) {
        this.properties_.addProperty("TitlePosition", position);
        this.modified_ = true;
    }

    public boolean getTitleShown() {
        return this.properties_.getProperty("TitleShown", true);
    }

    public void setTitleShown(boolean shown) {
        this.properties_.addProperty("TitleShown", new Boolean(shown));
        this.modified_ = true;
    }

    public double getTopOverrunTolerance() {
        return this.properties_.getProperty("TopOverrunTolerance", 0.25);
    }

    public void setTopOverrunTolerance(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            return;
        }
        this.properties_.addProperty("TopOverrunTolerance", new Double(fraction));
        this.modified_ = true;
    }

    public boolean getTrue3DLabels() {
        return this.properties_.getProperty("True3DLabels", this.viewMode_ == 2);
    }

    public void setTrue3DLabels(boolean true3D) {
        this.properties_.addProperty("True3DLabels", new Boolean(true3D));
        this.modified_ = true;
    }

    public void setView(double rotation, double tilt, double distance) {
        if (this.viewMode_ == 2) {
            super.setView(rotation, tilt, distance);
            this.clear();
            this.chart_.add3DTo(this);
        }
    }

    public void setShear(double sx, double sy) {
        if (this.viewMode_ == 1) {
            super.setShear(sx, sy);
            this.clear();
            this.chart_.add3DTo(this);
        }
    }

    public int getViewMode() {
        return this.viewMode_;
    }

    public void setViewMode(int viewMode) {
        if (this.chartBuilder_.supports(viewMode)) {
            this.setChartBuilder(this.chartBuilder_, viewMode);
        }
    }

    public void set2DStyleCustomizer(StyleCustomizer customizer) {
        this.properties_.set2DStyleCustomizer(customizer);
        this.modified_ = true;
    }

    public void set3DStyleCustomizer(StyleCustomizer customizer) {
        this.properties_.set3DStyleCustomizer(customizer);
        this.modified_ = true;
    }

    public Customizer get3DPlatform() {
        return (Customizer)this.properties_.getProperty("3DPlatform", null);
    }

    public void set3DPlatform(Customizer platform) {
        this.properties_.addProperty("3DPlatform", platform);
        this.modified_ = true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.lastSize_ = new Dimension(0, 0);
        this.setChartBuilder(this.chartBuilder_, this.viewMode_);
    }

    public void dataUpdate(DataUpdateEvent updateEvent) {
        if (this.data_.getRangeLow() < this.properties_.getDataRangeLow()) {
            this.properties_.setDataRangeLow(this.data_.getRangeLow());
        }
        if (this.data_.getRangeHigh() > this.properties_.getDataRangeHigh()) {
            this.properties_.setDataRangeHigh(this.data_.getRangeHigh());
        }
        this.modified_ = true;
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent changeEvent) {
        this.modified_ = true;
        this.repaint();
    }

    public void propertyUpdate(PropertyUpdateEvent updateEvent) {
        this.modified_ = true;
        this.repaint();
    }

    public void addChartClickListener(ChartClickListener listener) {
        this.clickHelper_.addChartClickListener(listener);
    }

    public void removeChartClickListener(ChartClickListener listener) {
        this.clickHelper_.removeChartClickListener(listener);
    }

    public void removeDefaultMouseListener() {
        if (this.defaultMouseListener_ != null) {
            super.removeMouseListener(this.defaultMouseListener_);
            this.defaultMouseListener_ = null;
        }
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.width == 0 || size.height == 0) {
            return new Dimension(300, 250);
        }
        return size;
    }
}

